/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import cursedflames.bountifulbaubles.BountifulBaubles;
import cursedflames.bountifulbaubles.item.ModItems;
import cursedflames.bountifulbaubles.item.base.AGenericItemBauble;
import cursedflames.bountifulbaubles.util.Config;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemTrinketBrokenHeart
extends AGenericItemBauble {
    public static final UUID MODIFIER_UUID = UUID.fromString("554f3929-4193-4ae5-a4da-4b528a89ca32");
    static Property regenHearts;

    public ItemTrinketBrokenHeart() {
        super("trinketBrokenHeart", BountifulBaubles.TAB);
        if (regenHearts == null) {
            BountifulBaubles.config.addPropBoolean(this.getRegistryName() + ".regenheartcontainers", "Items", "Whether sleeping regenerates heart containers. If disabled, any broken heart max health decrease will be permanent (until the player dies)", true, Config.EnumPropSide.SYNCED);
            regenHearts = BountifulBaubles.config.getSyncedProperty(this.getRegistryName() + ".regenheartcontainers");
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.TRINKET;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDamage(LivingDamageEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)ModItems.trinketBrokenHeart) == -1) {
            return;
        }
        float healthAfterDamage = player.func_110143_aJ() - event.getAmount();
        if (healthAfterDamage >= 1.0f) {
            return;
        }
        double maxHealthDamage = 1.0 - (double)healthAfterDamage;
        if ((double)player.func_110138_aP() <= maxHealthDamage) {
            return;
        }
        IAttributeInstance maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = maxHealth.func_111127_a(MODIFIER_UUID);
        double prevMaxHealthDamage = 0.0;
        if (modifier != null) {
            prevMaxHealthDamage = modifier.func_111164_d();
            maxHealth.func_111124_b(modifier);
        }
        modifier = new AttributeModifier(MODIFIER_UUID, "Broken Heart MaxHP drain", prevMaxHealthDamage - maxHealthDamage, 0);
        maxHealth.func_111121_a(modifier);
        if ((double)event.getAmount() - maxHealthDamage < 0.1) {
            event.setCanceled(true);
        }
        event.setAmount((float)Math.max((double)event.getAmount() - maxHealthDamage, 0.0));
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187602_cF, SoundCategory.PLAYERS, 0.7f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 0.8f);
    }

    @SubscribeEvent
    public static void onPlayerWake(PlayerWakeUpEvent event) {
        if (!regenHearts.getBoolean(true)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        IAttributeInstance maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = maxHealth.func_111127_a(MODIFIER_UUID);
        if (modifier != null) {
            maxHealth.func_111124_b(modifier);
        }
    }
}

